 ; Ŀ
 ;   Bsarn: search and replace block names - batch version.                
 ;   Copyright 2005 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Bsarn.                                                                
 ; 
 (DEFUN C:BSARN (/ oldstr newstr cas rew blnam chugs gnunam)
  (setvar "cmdecho" 0)
  (setq oldstr "land-")
  (setq newstr "land E ")
 ; Ŀ
 ;   Case sensitive?                                                       
 ; 
  (setq cas "Yes")
;  (setq cas "No")
 ; Ŀ
 ;   Step through the layer tables and impart rationality.                 
 ; 
  (setq rew t)
  (while (setq llist (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (assoc 2 llist)))
         (if (or (null cas) (= cas "Yes"))
             (setq chugs (chug oldstr newstr blnam))
             (setq chugs (chug (strcase oldstr) newstr (strcase blnam))))
         (if (< 0 (cadr chugs))
             (progn
                  (setq gnunam (car chugs))
                  (command ".rename" "block" blnam gnunam))))
 (princ))